/* Display the current directory in a GEM alert.
 * By Vincent Riviere, 2013.
 * Compile with: m68k-atari-mint-gcc getcwd.c -o getcwd.prg -Wall -O2 -fomit-frame-pointer -lgem -s
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <unistd.h>
#include <gem.h>

int main(int argc, char* argv[])
{
    char cwd[PATH_MAX];
    char message[PATH_MAX + 256];

    appl_init();

    if (getcwd(cwd, PATH_MAX) == NULL)
    {
        sprintf(message, FA_STOP "[getcwd(): error:|%s][OK]", strerror(errno));
        form_alert(1, message);
        appl_exit();
        return 1;
    }
    
    sprintf(message, FA_NOICON "[cwd = |%s][OK]", cwd);
    form_alert(1, message);

    appl_exit();

    return 0;
}
