


JOVE(1)                                                   JOVE(1)


NNAAMMEE
       jove - an interactive display-oriented text editor

SSYYNNOOPPSSIISS
       jjoovvee  [  --dd _d_i_r_e_c_t_o_r_y  ]  [  --ll _l_i_b_d_i_r ] [ --ss _s_h_a_r_e_d_i_r ] [
       --llss _b_o_t_h_d_i_r ] [ --JJ ] [ --jj ] [ --ww_n ] [ --tt _t_a_g ] [ ++_n _f_i_l_e ]
       [ ++//_p_a_t_t_e_r_n _f_i_l_e ] [ --pp _f_i_l_e ] [ _f_i_l_e...  ]
       jjoovvee --rr

DDEESSCCRRIIPPTTIIOONN
       JOVE  is  Jonathan's Own Version of Emacs.  It is based on
       the original  EMACS  editor  written  at  MIT  by  Richard
       Stallman.   Although  JOVE  is meant to be compatible with
       EMACS, there are some major differences  between  the  two
       editors   and   you   shouldn't  rely  on  their  behaving
       identically.

       JOVE works on any  reasonable  display  terminal  that  is
       described  in  the  _t_e_r_m_c_a_p  file (see TERMCAP(5) for more
       details).  When you  start  up  JOVE,  it  checks  to  see
       whether  you  have your _T_E_R_M environment variable set.  On
       most systems that will automatically be set  up  for  you,
       but  if  it's  not JOVE will ask you what kind of terminal
       you are using.  To avoid having to type  this  every  time
       you  run  JOVE  you can set your _T_E_R_M environment variable
       yourself.  How you do this depends on which shell you  are
       running.   If  you are running the C Shell, as most of you
       are, you type

            % setenv TERM _t_y_p_e

       and with the Bourne Shell, you type

            $ TERM= _t_y_p_e ; export TERM

       where _t_y_p_e is the name of the kind  of  terminal  you  are
       using  (e.g.,  vt100).   If  neither  of  these  works get
       somebody to help you.

IINNVVOOKKIINNGG JJOOVVEE
       If you run JOVE with no arguments you will be placed in an
       empty  buffer,  called _M_a_i_n_.  Otherwise, any arguments you
       supply are considered file names and each is ``given'' its
       own  buffer.   Only  the first file is actually read in --
       reading other files is deferred until you actually try  to
       use  the  buffers  they  are  attached  to.   This  is for
       efficiency's sake: most of the time, when you run JOVE  on
       a  big  list  of  files,  you end up editing only a few of
       them.

       The names of all of the files  specified  on  the  command
       line  are  saved in a buffer, called _*_m_i_n_i_b_u_f_*_.  The mini-
       buffer is a special JOVE buffer that is used when JOVE  is
       prompting  for  some  input to many commands (for example,



                           24 June 1993                         1





JOVE(1)                                                   JOVE(1)


       when JOVE is prompting for a file  name).   When  you  are
       being  prompted  for  a file name, you can type ^N (that's
       Control-N) and ^P to cycle through the list of files  that
       were specified on the command line.  The file name will be
       inserted where you are typing and then you can edit it  as
       if you typed it in yourself.

       JOVE recognizes the following switches:

       --dd _d_i_r_n_a_m_e
              _d_i_r_n_a_m_e  is  taken  to  be  the name of the current
              directory.  This is for systems that don't  have  a
              version of C shell that automatically maintains the
              _C_W_D environment variable.  If --dd is  not  specified
              on  a  system without a modified C shell, JOVE will
              have to figure out the  current  directory  itself,
              and  that  can  be  slow.   You  can  simulate  the
              modified C shell by putting the following lines  in
              your C shell initialization file (.cshrc):

                   alias cd        'cd \!*; setenv CWD $cwd'
                   alias popd      'popd \!*; setenv CWD $cwd'
                   alias pushd     'pushd \!*; setenv CWD $cwd'

       --ll _l_i_b_d_i_r
              Allows  the  user to specify the directory in which
              binary files required by JOVE can be found (default
              /usr/local/lib/jove).

       --ss _s_h_a_r_e_d_i_r
              Allows  the  user to specify the directory in which
              initialization files required by JOVE can be  found
              (default /usr/local/lib/jove).

       --llss _b_o_t_h_d_i_r
              Allows  the  user to specify the directory in which
              binary files and initialization files  required  by
              JOVE can be found.

       --JJ     Inhibits  reading of the system-wide initialization
              file (/usr/local/lib/jove/jove.rc).

       --jj     Inhibits reading of the user's initialization  file
              (~/.joverc).

       ++_n     Reads   the   file   designated  by  the  following
              argument, and positions  point  at  the  _n_'_t_h  line
              instead  of  the (default) first line.  This can be
              specified more than once but it doesn't make  sense
              to  use it twice on the same file; in that case the
              second one wins.  If no numeric argument  is  given
              after  the +, the point is positioned at the end of
              the file.




                           24 June 1993                         2





JOVE(1)                                                   JOVE(1)


       ++//_p_a_t_t_e_r_n
              Reads  the  file  designated   by   the   following
              argument, and positions point at the first match of
              the pattern.

       --pp _f_i_l_e
              Parses the  error  messages  in  _f_i_l_e.   The  error
              messages  are  assumed to be in a format similar to
              the C compiler, LINT, or GREP output.

       --tt _t_a_g Runs the _f_i_n_d_-_t_a_g command on _t_a_g (see ctags(1)).

       --ww_n    Divides  the  window  into  _n  windows  (if  _n   is
              ommitted,  it  is taken to be 2).  Subsequent files
              in the list are read in and displayed in succeeding
              windows.

RREECCOOVVEERRIINNGG BBUUFFFFEERRSS AAFFTTEERR AA CCRRAASSHH
       The  --rr option of jove runs the JOVE recover program.  Use
       this when the system crashes,  or  JOVE  crashes,  or  you
       accidently get logged out while in JOVE.  If there are any
       buffers to be recovered, this will find them.

       Recover looks for JOVE buffers that are  left  around  and
       are  owned  by  you.   (You  cannot recover other peoples'
       buffers, obviously.)  If there were no buffers  that  were
       modified  at  the  time  of  the  crash  or there were but
       recover can't get its hands on them, you will be  informed
       with   the  message,  ``There  is  nothing  to  recover.''
       Otherwise, recover prints the date and time of the version
       of  the  buffers  it  has,  and  then waits for you type a
       command.

       To get a list of the buffers recover knows about, use  the
       _l_i_s_t  command.   This  will  list  all the buffers and the
       files and the number of lines associated with them.   Next
       to  each  buffer  is a number.  When you want to recover a
       buffer, use the _g_e_t command.  The  syntax  is  _g_e_t  _b_u_f_f_e_r
       _f_i_l_e_n_a_m_e  where  _b_u_f_f_e_r is either the buffer's name or the
       number at the beginning of the line.  If  you  don't  type
       the  buffer  name or the filename, recover will prompt you
       for them.

       If there are a lot of buffers and you want to recover  all
       of  them, use the _r_e_c_o_v_e_r command.  This will recover each
       buffer to the name of the buffer with ``.#'' prepended  to
       the  name  (so  that the original isn't over-written).  It
       asks for each file and if you want to restore that  buffer
       to that name you type ``yes''.  If you want to recover the
       file but to a different name, just type the new  name  in.
       If  you  type ``no'' recover will skip that file and go on
       to the next one.

       If you want to look at a buffer before deciding to recover



                           24 June 1993                         3





JOVE(1)                                                   JOVE(1)


       it,  use  the _p_r_i_n_t command.  The syntax for this is _p_r_i_n_t
       _b_u_f_f_e_r where _b_u_f_f_e_r  again  is  either  its  name  or  the
       number.  You can type ^C if you want to abort printing the
       file to the terminal, and recover  will  respond  with  an
       appropriate message.

       When  you're  done and have all the buffers you want, type
       the _q_u_i_t command to leave.  You will then be asked whether
       it's  okay  to  delete  the  tmp  files.  Most of the time
       that's okay and you should type  ``yes''.   When  you  say
       that,  JOVE  removes  all  traces of those buffers and you
       won't be able to look at them again.   (If  you  recovered
       some  buffers  they will still be around, so don't worry.)
       So, if you're not  sure  whether  you've  gotten  all  the
       buffers,  you  should answer ``no'' so that you'll be able
       to run recover again at a  later  time  (presumably  after
       you've figured out which ones you want to save).  If there
       were more than one crashed JOVE session,  _q_u_i_t  will  move
       you on to dealing with the next one instead of exiting.

       If you type ^C at any time other than when you're printing
       a file to the terminal, recover will exit without a  word.
       If  you do this but wish you hadn't, just type ``jove -r''
       to the shell again, and you will be put back with no loss.

GGEETTTTIINNGG HHEELLPP
       Once  in JOVE, there are several commands available to get
       help.  To execute any JOVE command,  you  type  ``<ESC>  X
       command-name'' followed by <Return>.  To get a list of all
       the JOVE commands you type ``<ESC> X'' followed by  ``?''.
       The  _d_e_s_c_r_i_b_e_-_b_i_n_d_i_n_g_s  command  can be used to get a list
       containing each key, and its associated command (that  is,
       the  command  that  gets executed when you type that key).
       If you want to save the list of bindings, you can set  the
       jove  variable _s_e_n_d_-_t_y_p_e_o_u_t_-_t_o_-_b_u_f_f_e_r to ON (using the _s_e_t
       command), and then execute the _d_e_s_c_r_i_b_e_-_b_i_n_d_i_n_g_s  command.
       This  will create a buffer and put in it the bindings list
       it normally would have printed on the  screen.   Then  you
       can  save  that  buffer to a file and print it to use as a
       quick reference card.  (See VARIABLES below.)

       Once you know the name of a command, you can find out what
       it  does  with the _d_e_s_c_r_i_b_e_-_c_o_m_m_a_n_d command, which you can
       invoke quickly by typing ``ESC ?''.  The  _a_p_r_o_p_o_s  command
       will  give  you  a list of all the command with a specific
       string in their names.  For example, if you want  to  know
       the  names  of  all  the  commands that are concerned with
       windows, you can run ``apropos'' with the keyword  _w_i_n_d_o_w_.

       If   the   initialization   file   has  provided  specific
       keybindings for your terminal, it should also be  possible
       to view the keyboard layout with the keychart macro.

       If you're not familar with the EMACS command set, it would



                           24 June 1993                         4





JOVE(1)                                                   JOVE(1)


       be worth your while to use run  TEACHJOVE.   Do  do  that,
       just  type  ``teachjove''  to  your  shell and you will be
       placed in JOVE in a file  which  contains  directions.   I
       highly recommend this for beginners; you may save yourself
       a lot of time and headaches.

KKEEYY BBIINNDDIINNGGSS aanndd VVAARRIIAABBLLEESS
       You can alter  the  key  bindings  in  JOVE  to  fit  your
       personal  tastes.  That is, you can change what a key does
       every time you strike it.  For example, by default the  ^N
       key is bound to the command _n_e_x_t_-_l_i_n_e and so when you type
       it you move down a line.  If you want to change a  binding
       or  add  a  new one, you use the _b_i_n_d_-_t_o_-_k_e_y command.  The
       syntax is ``bind-to-key <command> key''.

       You can also change the way JOVE behaves in little ways by
       changing the value of some variables with the _s_e_t command.
       The syntax is ``set <variable> value'', where value  is  a
       number or a string, or ``on'' or ``off'', depending on the
       context.  For example, if you want  JOVE  to  make  backup
       files,  you  set  the  ``make-backup-files''  variable  to
       ``on''.  To see the value of a variable, use  the  ``print
       <variable>'' command.

IINNIITTIIAALLIIZZAATTIIOONN
       JOVE  first  reads  the  system-wide  initialization  file
       (/usr/local/lib/jove/jove.rc)  which  provides  reasonable
       defaults  for your installation and loads standard macros.
       It will normally observe your TERM environment variable in
       order  to provide terminal-specific key bindings and a map
       of your keyboard (see the standard ``keychart'' macro).

       JOVE then automatically reads further  commands  from  the
       initialization  file called ``.joverc'' (``jove.rc'' under
       MSDOS) in your HOME directory.  In this file you can place
       commands  that  you  would  normally type in JOVE.  If you
       like to rearrange the key bindings and set some  variables
       every  time you get into JOVE, you should put them in your
       initialization file.  Here are a few lines from mine:
            set match-regular-expressions on
            1 auto-execute-command auto-fill /tmp/Re\|.*drft
            bind-to-key i-search-forward ^\
            bind-to-key i-search-reverse ^R
            bind-to-key find-tag-at-point ^[^T
            bind-to-key scroll-down ^C
            bind-to-key grow-window ^Xg
            bind-to-key shrink-window ^Xs
       (Note that  the  Control  Characters  can  be  either  two
       character  sequences  (e.g. ^ and C together as ^C) or the
       actual control character.  If you want  to  use  an  ^  by
       itself  you  must  BackSlash  it  (e.g., bind-to-key grow-
       window ^X\^ binds grow-window to ``^X^'').





                           24 June 1993                         5





JOVE(1)                                                   JOVE(1)


EENNVVIIRROONNMMEENNTT
       If the variable LLCC__CCTTYYPPEE (see eennvviirroonn(5)) is  not  set  in
       the  environment, the operational behavior of JOVE for the
       LLCC__CCTTYYPPEE locale category is determined by the value of the
       LLAANNGG environment variable.  If LLCC__AALLLL is set, its contents
       are used to  override  both  the  LLAANNGG  and  the  LLCC__CCTTYYPPEE
       variable.   If  none  of the above variables is set in the
       environment, the "C" (U.S. style)  locale  determines  how
       JOVE behaves.

       LLCC__CCTTYYPPEE
              Determines   how   JOVE  handles  characters.  When
              LLCC__CCTTYYPPEE is set to a valid value, JOVE can  display
              and  handle  text  and  filenames  containing valid
              characters  for   that   locale.   In   particular,
              characters will be correctly recognised as upper or
              lower case and  displayed  if  printable.   However
              JOVE  cannot  display  or handle Extended Unix Code
              (EUC) characters which are more than 1  byte  wide.
              In the "C" locale, only characters from 7-bit ASCII
              are valid (all characters with the eighth  bit  set
              being  displayed  in  octal).  In  the "iso_8859_1"
              locale (if supported by the OS), the  full  Latin-1
              alphabet  is  available.  The  JOVE  variable ``lc-
              ctype'' can be used to change the locale while JOVE
              is running.

SSOOMMEE MMIINNOORR DDEETTAAIILLSS
       You  should  type ^\ instead of ^S in many instances.  For
       example, the way to search for a string is  documented  as
       being  ``^S'' but in reality you should type ``^\''.  This
       is because ^S is the XOFF character (what gets  sent  when
       you  type the NO SCROLL key), and clearly that won't work.
       The XON character is ``^Q'' (what gets sent when you  type
       NO  SCROLL  again)  which is documented as the way to do a
       quoted-insert.  The  alternate  key  for  this  is  ``^^''
       (typed  as ``^`'' on vt100's and its look-alikes).  If you
       want to enable ^S and ^Q and you know what you are  doing,
       you can put the line:
            set allow-^S-and-^Q on
       in your initialization file.

       If your terminal has a metakey and you turn on the ``meta-
       key'' variable, JOVE will  use  it  to  generate  commands
       which  would  otherwise  start  with  an  ESC.   JOVE will
       automatically  turn  on  ``meta-key''   if   the   METAKEY
       environment  variable  exists.   This is useful for if you
       have different terminals (e.g., one at  home  and  one  at
       work)  and  one  has  a  metakey  and  the  other doesn't.
       However, if a locale which recognises 8-bit characters  is
       in  force,  a  metakey  may be better used to generate the
       extra characters (so leave the ``meta-key'' variable off).





                           24 June 1993                         6





JOVE(1)                                                   JOVE(1)


FFIILLEESS
       /usr/local/lib/jove/jove.rc -- system-wide initialization file
       /usr/local/lib/jove/jove.rc.$TERM -- terminal-specific initialization file
       /usr/local/lib/jove/keychart.$TERM -- terminal-specific help file
       /usr/local/lib/jove/macros -- standard macros file
       ~/.joverc -- personal initialization file
       /usr/tmp -- where temporary files are stored
       /usr/local/lib/jove/teach-jove -- the interactive tutorial
       /usr/local/lib/jove/recover -- the recovery program
       /usr/local/lib/jove/portsrv -- for running shells in windows (pdp11 only)

EENNVVIIRROONNMMEENNTT VVAARRIIAABBLLEESS
       TERM -- your terminal type
       METAKEY -- if defined, sets the ``meta-key'' variable
       SHELL -- the shell to be used by the ``shell'' and other commands
       COMSPEC -- (on MSDOS) used if SHELL is not defined
       MAIL -- to initialize the ``mailbox'' variable
       JOVELIB -- overrides /usr/local/lib/jove unless overridden by -l
       JOVESHARE -- overrides /usr/local/lib/jove unless overridden by -s
       TMPDIR -- overrides /usr/tmp as directory for temporary files
       LC_ALL, LC_CTYPE, LANG -- to set the locale

SSEEEE AALLSSOO
       ctags(1) -- to generate tags for the find-tag command and the -t command-line
       option
       ed(1) -- for a description of regular expressions
       teachjove(1) -- for an interactive JOVE tutorial.

DDIIAAGGNNOOSSTTIICCSS
       JOVE diagnostics are meant to be self-explanatory, but you
       are advised to seek help whenever you are  confused.   You
       can  easily  lose  a lot of work if you don't know EXACTLY
       what you are doing.

BBUUGGSS
       Lines can't be more than 1024 characters long.

       Searches can't cross line boundaries.

AAUUTTHHOORR
       Jonathan Payne
















                           24 June 1993                         7


