{ Torus zonder lichtbron }
{$G+,N+}
Program ToRuS;

Uses crt;

const k=2;
const colors = 163;
Const NumOfBlobs = 99;  {=Apoints}
Const Form1 : Array[1..5,1..5] Of Byte =
            ((k*0,k*3,k*3,k*3,k*0),
             (k*2,k*4,k*4,k*4,k*2),
             (k*3,k*4,k*5,k*4,k*3),
             (k*2,k*4,k*4,k*4,k*2),
             (k*0,k*3,k*3,k*3,k*0));
Type Blobs = Array[1..NumOfBlobs] of Record
                                      x1,y1,Xadd,Yadd : Integer;
                                      Form            : Byte;
                                    end;
Var Blob : Blobs;
    Vp1  : Pointer;
    vvga : word;
    S    : Array[0..99] Of Byte;
    Zvalue : Array[0..99] of Integer;
    fps  : longint;
    h1,m1,s1,hu1,h2,m2,s2,hu2 : Word;
    SinTab : Array[0..720] Of Real;
    CosTab : Array[0..720] of Real;

CONST

  APOINTS = 99;
  AFACES  = 99;

POINT : ARRAY[0..99,0..2] OF INTEGER=(
  (   19,    0,  -13),
  (    8,    0,  -21),
  (   -7,    0,  -22),
  (  -18,    0,  -13),
  (  -22,    0,    1),
  (  -18,    0,   14),
  (   -7,    0,   22),
  (    7,    0,   22),
  (   19,    0,   14),
  (   23,    0,    1),
  (    4,   47,  -13),
  (   -6,   41,  -21),
  (  -17,   32,  -22),
  (  -26,   26,  -13),
  (  -30,   23,    0),
  (  -26,   26,   14),
  (  -17,   32,   22),
  (   -6,   41,   22),
  (    3,   47,   14),
  (    7,   50,    0),
  (  -37,   77,  -13),
  (  -40,   66,  -21),
  (  -45,   53,  -22),
  (  -48,   42,  -13),
  (  -50,   37,    0),
  (  -48,   42,   14),
  (  -45,   52,   22),
  (  -40,   66,   22),
  (  -37,   77,   14),
  (  -35,   81,    0),
  (  -87,   77,  -13),
  (  -83,   66,  -21),
  (  -79,   53,  -22),
  (  -75,   42,  -13),
  (  -74,   37,    0),
  (  -75,   42,   14),
  (  -79,   52,   22),
  (  -83,   66,   22),
  (  -87,   77,   14),
  (  -88,   81,    0),
  ( -127,   47,  -13),
  ( -118,   41,  -21),
  ( -106,   32,  -22),
  (  -97,   26,  -13),
  (  -94,   23,    0),
  (  -97,   26,   14),
  ( -106,   32,   22),
  ( -118,   41,   22),
  ( -127,   47,   14),
  ( -130,   50,    0),
  ( -142,    0,  -13),
  ( -131,    0,  -21),
  ( -117,    0,  -22),
  ( -105,    0,  -13),
  ( -101,    0,    0),
  ( -105,    0,   14),
  ( -117,    0,   22),
  ( -131,    0,   22),
  ( -142,    0,   14),
  ( -147,    0,    0),
  ( -127,  -47,  -13),
  ( -118,  -41,  -21),
  ( -106,  -32,  -22),
  (  -97,  -26,  -13),
  (  -94,  -23,    0),
  (  -97,  -26,   14),
  ( -106,  -32,   22),
  ( -118,  -41,   22),
  ( -127,  -47,   14),
  ( -130,  -50,    0),
  (  -87,  -77,  -13),
  (  -83,  -66,  -21),
  (  -79,  -53,  -22),
  (  -75,  -42,  -13),
  (  -74,  -37,    0),
  (  -75,  -42,   14),
  (  -79,  -52,   22),
  (  -83,  -66,   22),
  (  -87,  -77,   14),
  (  -88,  -81,    0),
  (  -37,  -77,  -13),
  (  -40,  -66,  -21),
  (  -45,  -53,  -22),
  (  -48,  -42,  -13),
  (  -50,  -37,    0),
  (  -48,  -42,   14),
  (  -45,  -52,   22),
  (  -40,  -66,   22),
  (  -37,  -77,   14),
  (  -35,  -81,    0),
  (    4,  -47,  -13),
  (   -6,  -41,  -21),
  (  -17,  -32,  -22),
  (  -26,  -26,  -13),
  (  -30,  -23,    0),
  (  -26,  -26,   14),
  (  -17,  -32,   22),
  (   -6,  -41,   22),
  (    3,  -47,   14),
  (    7,  -50,    0));

PLANES : ARRAY[0..99,0..3] of INTEGER=(
(0,1,11,10),
(1,2,12,11),
(2,3,13,12),
(3,4,14,13),
(4,5,15,14),
(5,6,16,15),
(6,7,17,16),
(7,8,18,17),
(8,9,19,18),
(9,0,10,19),
(10,11,21,20),
(11,12,22,21),
(12,13,23,22),
(13,14,24,23),
(14,15,25,24),
(15,16,26,25),
(16,17,27,26),
(17,18,28,27),
(18,19,29,28),
(19,10,20,29),
(20,21,31,30),
(21,22,32,31),
(22,23,33,32),
(23,24,34,33),
(24,25,35,34),
(25,26,36,35),
(26,27,37,36),
(27,28,38,37),
(28,29,39,38),
(29,20,30,39),
(30,31,41,40),
(31,32,42,41),
(32,33,43,42),
(33,34,44,43),
(34,35,45,44),
(35,36,46,45),
(36,37,47,46),
(37,38,48,47),
(38,39,49,48),
(39,30,40,49),
(40,41,51,50),
(41,42,52,51),
(42,43,53,52),
(43,44,54,53),
(44,45,55,54),
(45,46,56,55),
(46,47,57,56),
(47,48,58,57),
(48,49,59,58),
(49,40,50,59),
(50,51,61,60),
(51,52,62,61),
(52,53,63,62),
(53,54,64,63),
(54,55,65,64),
(55,56,66,65),
(56,57,67,66),
(57,58,68,67),
(58,59,69,68),
(59,50,60,69),
(60,61,71,70),
(61,62,72,71),
(62,63,73,72),
(63,64,74,73),
(64,65,75,74),
(65,66,76,75),
(66,67,77,76),
(67,68,78,77),
(68,69,79,78),
(69,60,70,79),
(70,71,81,80),
(71,72,82,81),
(72,73,83,82),
(73,74,84,83),
(74,75,85,84),
(75,76,86,85),
(76,77,87,86),
(77,78,88,87),
(78,79,89,88),
(79,70,80,89),
(80,81,91,90),
(81,82,92,91),
(82,83,93,92),
(83,84,94,93),
(84,85,95,94),
(85,86,96,95),
(86,87,97,96),
(87,88,98,97),
(88,89,99,98),
(89,80,90,99),
(90,91,1,0),
(91,92,2,1),
(92,93,3,2),
(93,94,4,3),
(94,95,5,4),
(95,96,6,5),
(96,97,7,6),
(97,98,8,7),
(98,99,9,8),
(99,90,0,9));

Procedure Set_mode(mode : byte); assembler;
asm mov ah,0; mov al,mode; int 10h; end;

Procedure Blur; Assembler;
Asm
    Mov   Ax,Vvga
    Mov   Es,Ax
    Mov   Cx,64000
    Xor   Si,Si
@Loop1:
    Xor   Dx,Dx
    Xor   Bx,Bx
    Mov   Bl,Es:[Si]      {0}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+319]  {319}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+320]  {320}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+321]  {321}
    Add   Dx,Bx
    Shr   Dx,2
    Jz    @Skip
    Dec   Dl
@Skip:
    Mov   Es:[Si+320],Dl
    Inc   Si
    Dec   Cx
    Jnz   @Loop1

    Push  Ds
    Mov   Ax,Vvga
    Mov   Es,Ax
    Mov   Ds,Ax
    Mov   Cx,16000
    Xor   Si,Si
    Xor   Di,Di
    Db 66h
    Rep  Movsw
    Pop   Ds
End;

Procedure Flip_pages(origin,dest : word); assembler;
asm
  Push ds
  mov ax,dest
  mov es,ax
  mov ax,origin
  mov ds,ax
  xor si,si
  xor di,di
  mov cx,16000
  db 66h
  rep movsw
  Pop ds
end;

Procedure Clear_page(What : word); assembler;
asm
  mov ax,what
  mov es,ax
  xor ax,ax
  mov cx,16000
  db 66h
  rep stosw
end;

Procedure SetPal(ColorNumber : byte; R,G,B : Byte);
Begin
  Port[$3C8] := ColorNumber;
  Port[$3C9] := R;
  Port[$3C9] := G;
  Port[$3C9] := B;
End;

Procedure RotX(Var Y,Z : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(Y*CosTab[phi]-Z*SinTab[Phi]);
  Tmp2:=(Y*SinTab[Phi]+Z*CosTab[phi]);
  Y:=Tmp1; Z:=Tmp2;
end;

Procedure RotY(Var X,Z : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(X*CosTab[Phi]+Z*SinTab[Phi]);
  Tmp2:=(-X*SinTab[Phi]+Z*CosTab[Phi]);
  X:=Tmp1; Z:=Tmp2;
End;

Procedure RotZ(Var X,Y : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(X*CosTab[Phi]-Y*SinTab[Phi]);
  Tmp2:=(X*SinTab[Phi]+Y*CosTab[Phi]);
  X:=Tmp1; Y:=Tmp2;
End;

Procedure DrawBlob(X,Y,F : Integer);
Var I,J,Pixel,Form : Byte;
Begin
  For I:=1 to 5 Do
    For J:=1 to 5 Do Begin
      Pixel:=Mem[Vvga:(Y+I)*320+(X+J)]+Form1[i,j];
      if pixel>=colors-1 then pixel:=colors-1;
      Mem[Vvga:(Y+I)*320+(X+J)]:=Pixel;
    End;
End;

Procedure ShowTorusNew;
const a=218; {218}
      xoff=170; {220}
      yoff=100; {100}
Var i,j   : integer;
    p     : Array[0..99,0..2] of Integer;
    x,y,z : real;
    Phi   : Longint;
    phi2 : real;
Begin
  Phi:=0;
  phi2:=0;
  clear_page(Vvga);
  Repeat
    for phi:=phi to phi+5 do
      For i:=0 to 99 do Begin
        X:=Point[I,0] + 77; Y:=Point[I,1]; Z:=Point[I,2]-1;

        RotZ(X,Y,Phi mod 720);
        RotX(Y,Z,Phi mod 720);
        RotY(X,Z,Phi mod 720);

        P[I,0]:=Round(X*A/(Z-A))+XoFF;
        P[I,1]:=Round(Y*A/(Z-A))+YoFF;
        drawblob(p[i,0],p[i,1],0);
      end;
    phi:=phi+1;
    blur;
    Flip_pages(Vvga,$a000);
    Inc(fps);
  Until Keypressed;
end;

Procedure Init;
Var I : Integer;
    r,g,b : byte;
Begin
  SET_MODE($13);
  for i:=0 to colors do begin
    if i=0 then r:=0 else r:=trunc(63*exp(7   * ln(i/(colors-10))));
    if i=0 then g:=0 else g:=trunc(63*exp(2   * ln(i/(colors-10))));
    if i=0 then b:=0 else b:=trunc(63*exp(3   * ln(i/(colors-10))));
    if r>63 then r:=63; if g>63 then g:=63; if b>63 then b:=63;
    setpal(i,r,g,b);
  end;
  Fps:=1;
  GetMem(Vp1,64000); Vvga:=Seg(vp1^);
  clear_page(Vvga);
  For i:=0 to 720 do begin
      sintab[i]:=Sin(i*2*Pi/720);
      costab[i]:=Cos(i*2*Pi/720);
  end;
end;

BEGIN
  Init;
  showtorusnew;
  set_mode($3);
  freemem(vp1,64000);
END.