{$G+ $N+ $E-}
Program Particle_Sphere;

Uses crt;

const colors = 63;
const c = 5;
const c2=64;
Const NumOfBlobs = 339;  {=Apoints}
Const Form1 : Array[1..5,1..5] Of Byte =
            ((0+0,3+c,3+c,3+c,0+0),
             (2+c,4+c,4+c,4+c,2+c),
             (3+c,4+c,5+c,4+c,3+c),
             (2+c,4+c,4+c,4+c,2+c),
             (0+0,3+c,3+c,3+c,0+0));
Const Form2 : Array[1..5,1..5] Of Byte =
            ((0+64,3+c2,3+c2,3+c2,0+64),
             (2+c2,4+c2,4+c2,4+c2,2+c2),
             (3+c2,4+c2,5+c2,4+c2,3+c2),
             (2+c2,4+c2,4+c2,4+c2,2+c2),
             (0+64,3+c2,3+c2,3+c2,0+64));
Var Vp1  : Pointer;
    vvga : word;
    fps  : longint;
    h1,m1,s1,hu1,h2,m2,s2,hu2 : Word;
    SinTab : Array[0..720] Of Real;
    CosTab : Array[0..720] Of Real;
CONST
        Apoints = 339;
        NumOfFaces    = 675;
POINT : Array[0..Apoints,0..2] of Integer =
((0,74,0),
(-70,-25,2),
(37,-25,60),
(33,-25,-62),
(-10,74,0),
(-21,71,0),
(-31,67,1),
(-41,62,1),
(-50,55,1),
(-57,47,1),
(-64,38,2),
(-69,28,2),
(-72,18,2),
(-74,7,2),
(-75,-3,2),
(-73,-14,2),
(6,74,9),
(11,71,18),
(17,67,27),
(22,62,35),
(26,55,42),
(31,47,49),
(34,38,54),
(37,28,58),
(38,18,61),
(39,7,63),
(40,-3,63),
(39,-14,62),
(5,74,-9),
(10,71,-19),
(15,67,-28),
(19,62,-37),
(23,55,-44),
(27,47,-51),
(30,38,-57),
(32,28,-61),
(34,18,-64),
(35,7,-66),
(35,-3,-66),
(34,-14,-65),
(-67,-30,11),
(-63,-34,21),
(-57,-38,29),
(-50,-40,37),
(-42,-42,45),
(-33,-43,51),
(-23,-43,56),
(-13,-42,60),
(-2,-40,63),
(7,-38,64),
(18,-34,64),
(28,-30,62),
(44,-30,52),
(50,-34,44),
(54,-38,35),
(58,-40,24),
(60,-42,14),
(61,-43,3),
(61,-43,-7),
(59,-42,-18),
(56,-40,-29),
(52,-38,-39),
(47,-34,-48),
(40,-30,-56),
(23,-30,-65),
(13,-34,-65),
(3,-38,-65),
(-7,-40,-63),
(-17,-42,-59),
(-27,-43,-55),
(-37,-43,-49),
(-45,-42,-42),
(-53,-40,-34),
(-59,-38,-25),
(-64,-34,-16),
(-68,-30,-7),
(-5,74,9),
(-16,72,10),
(0,72,19),
(-27,68,11),
(-11,71,20),
(5,68,29),
(-37,63,12),
(-22,67,22),
(-6,67,31),
(10,63,38),
(-47,56,13),
(-33,62,24),
(-18,64,34),
(-1,62,41),
(15,56,46),
(-55,47,15),
(-44,53,27),
(-30,57,37),
(-14,57,46),
(2,53,52),
(18,47,54),
(-63,36,16),
(-53,42,29),
(-41,46,41),
(-27,47,50),
(-11,46,57),
(5,42,61),
(21,36,61),
(-68,23,17),
(-61,28,31),
(-51,31,44),
(-38,33,54),
(-23,33,62),
(-8,31,67),
(8,28,68),
(24,23,67),
(-72,9,17),
(-66,11,32),
(-58,13,45),
(-47,14,56),
(-34,14,65),
(-20,14,70),
(-4,13,73),
(10,11,73),
(25,9,69),
(-73,-4,16),
(-68,-5,30),
(-61,-6,42),
(-52,-7,53),
(-41,-7,62),
(-28,-7,69),
(-14,-7,73),
(0,-6,74),
(13,-5,73),
(27,-4,70),
(-71,-18,14),
(-67,-21,26),
(-60,-24,36),
(-53,-26,46),
(-43,-27,55),
(-32,-27,61),
(-21,-27,66),
(-8,-26,70),
(3,-24,71),
(16,-21,70),
(28,-18,67),
(11,74,0),
(17,72,8),
(17,72,-10),
(23,68,17),
(24,71,-1),
(22,68,-19),
(30,63,26),
(31,67,8),
(30,67,-10),
(28,63,-28),
(35,56,34),
(38,62,16),
(39,64,-1),
(37,62,-19),
(33,56,-36),
(41,47,40),
(46,53,24),
(48,57,7),
(47,57,-10),
(44,53,-28),
(38,47,-43),
(46,36,46),
(53,42,31),
(57,46,15),
(57,47,-2),
(55,46,-19),
(50,42,-35),
(42,36,-49),
(50,23,50),
(58,28,37),
(64,31,22),
(67,33,5),
(66,33,-10),
(62,31,-26),
(55,28,-41),
(46,23,-54),
(51,9,53),
(61,11,41),
(68,13,27),
(72,14,12),
(73,14,-2),
(71,14,-18),
(66,13,-32),
(58,11,-46),
(47,9,-57),
(51,-4,54),
(60,-5,44),
(68,-6,32),
(72,-7,18),
(75,-7,4),
(74,-7,-9),
(71,-7,-23),
(65,-6,-36),
(57,-5,-48),
(47,-4,-58),
(48,-18,54),
(56,-21,45),
(62,-24,34),
(67,-26,22),
(69,-27,10),
(70,-27,-2),
(68,-27,-15),
(65,-26,-27),
(60,-24,-38),
(53,-21,-49),
(44,-18,-58),
(-5,74,-9),
(0,72,-19),
(-17,72,-9),
(3,68,-29),
(-12,71,-20),
(-27,68,-9),
(8,63,-39),
(-8,67,-31),
(-24,67,-21),
(-38,63,-10),
(11,56,-48),
(-4,62,-41),
(-20,64,-33),
(-35,62,-22),
(-48,56,-10),
(15,47,-56),
(-1,53,-52),
(-17,57,-45),
(-32,57,-35),
(-46,53,-24),
(-56,47,-11),
(17,36,-63),
(1,42,-61),
(-15,46,-57),
(-30,47,-49),
(-44,46,-38),
(-55,42,-26),
(-64,36,-12),
(19,23,-68),
(3,28,-69),
(-12,31,-67),
(-28,33,-61),
(-42,33,-52),
(-54,31,-41),
(-63,28,-27),
(-69,23,-12),
(20,9,-71),
(5,11,-74),
(-9,13,-73),
(-24,14,-69),
(-38,14,-62),
(-51,14,-53),
(-61,13,-41),
(-68,11,-27),
(-73,9,-12),
(22,-4,-71),
(8,-5,-74),
(-6,-6,-74),
(-20,-7,-72),
(-33,-7,-67),
(-45,-7,-59),
(-55,-7,-49),
(-64,-6,-38),
(-70,-5,-25),
(-74,-4,-11),
(23,-18,-69),
(11,-21,-71),
(-1,-24,-71),
(-13,-26,-69),
(-25,-27,-65),
(-37,-27,-59),
(-47,-27,-52),
(-56,-26,-43),
(-63,-24,-32),
(-68,-21,-21),
(-72,-18,-9),
(-66,-35,2),
(-62,-40,-7),
(-62,-40,11),
(-58,-45,-16),
(-59,-46,2),
(-56,-45,20),
(-51,-48,-25),
(-54,-52,-7),
(-53,-52,11),
(-49,-48,29),
(-43,-51,-33),
(-46,-56,-16),
(-47,-58,1),
(-45,-56,19),
(-40,-51,36),
(-33,-53,-41),
(-36,-60,-25),
(-38,-64,-7),
(-37,-64,10),
(-35,-60,27),
(-30,-53,43),
(-21,-54,-47),
(-24,-63,-32),
(-25,-69,-16),
(-26,-71,0),
(-24,-69,18),
(-22,-63,34),
(-18,-54,48),
(-8,-53,-52),
(-9,-63,-39),
(-9,-70,-24),
(-9,-74,-8),
(-9,-74,8),
(-8,-70,24),
(-6,-63,39),
(-4,-53,52),
(5,-50,-55),
(7,-60,-44),
(8,-68,-30),
(9,-73,-16),
(10,-74,0),
(11,-73,15),
(10,-68,29),
(10,-60,43),
(9,-50,55),
(18,-45,-57),
(23,-54,-47),
(26,-61,-35),
(29,-66,-22),
(31,-68,-8),
(31,-68,5),
(31,-66,20),
(29,-61,33),
(26,-54,45),
(22,-45,55),
(30,-38,-57),
(36,-44,-48),
(41,-50,-38),
(45,-54,-26),
(48,-56,-14),
(49,-57,-1),
(49,-56,10),
(47,-54,23),
(44,-50,35),
(40,-44,45),
(34,-38,55));

Procedure Set_mode(mode : byte); assembler;
asm mov ah,0; mov al,mode; int 10h; end;

Procedure Blur; Assembler;
Asm
    Mov   Ax,Vvga
    Mov   Es,Ax
    Mov   Cx,64000
    Xor   Si,Si
@Loop1:
    Xor   Dx,Dx
    Xor   Bx,Bx
    Mov   Bl,Es:[Si]      {0}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+319]  {319}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+320]  {320}
    Add   Dx,Bx
    Mov   Bl,Es:[Si+321]  {321}
    Add   Dx,Bx
    Shr   Dx,2
    Jz    @Skip
    Dec   Dl
@Skip:
    Mov   Es:[Si+320],Dl
    Inc   Si
    Dec   Cx
    Jnz   @Loop1

    Push  Ds
    Mov   Ax,Vvga
    Mov   Es,Ax
    Mov   Ds,Ax
    Mov   Cx,16000
    Xor   Si,Si
    Xor   Di,Di
    Db 66h
    Rep  Movsw
    Pop   Ds
End;

Procedure Flip_pages(origin,dest : word); assembler;
asm
  Push ds
  mov ax,dest
  mov es,ax
  mov ax,origin
  mov ds,ax
  xor si,si
  xor di,di
  mov cx,16000
  db 66h
  rep movsw
  Pop ds
end;

Procedure Clear_page(What : word); assembler;
asm
  mov ax,what
  mov es,ax
  xor ax,ax
  mov cx,16000
  db 66h
  rep stosw
end;

Procedure SetPal(ColorNumber : byte; R,G,B : Byte);
Begin
  Port[$3C8] := ColorNumber;
  Port[$3C9] := R;
  Port[$3C9] := G;
  Port[$3C9] := B;
End;

Procedure RotX(Var Y,Z : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(Y*CosTab[phi]-Z*SinTab[Phi]);
  Tmp2:=(Y*SinTab[Phi]+Z*CosTab[phi]);
  Y:=Tmp1; Z:=Tmp2;
end;

Procedure RotY(Var X,Z : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(X*CosTab[Phi]+Z*SinTab[Phi]);
  Tmp2:=(-X*SinTab[Phi]+Z*CosTab[Phi]);
  X:=Tmp1; Z:=Tmp2;
End;

Procedure RotZ(Var X,Y : Real;Phi : Word);
Var Tmp1,Tmp2 : Real;
Begin
  Tmp1:=(X*CosTab[Phi]-Y*SinTab[Phi]);
  Tmp2:=(X*SinTab[Phi]+Y*CosTab[Phi]);
  X:=Tmp1; Y:=Tmp2;
End;

Procedure DrawBlob(X,Y,F : Integer);
Var I,J,Pixel,Form : Byte;
Begin
  For I:=1 to 5 Do
    For J:=1 to 5 Do Begin
      Pixel:=Mem[Vvga:(Y+I)*320+(X+J)]+Form1[i,j];
      if pixel>=63 then pixel:=63;
      Mem[Vvga:(Y+I)*320+(X+J)]:=Pixel;
    End;
End;

Procedure DrawBlob2(X,Y,F : Integer);
Var I,J,Pixel,Form : Byte;
Begin
  For I:=1 to 5 Do
    For J:=1 to 5 Do Begin
      Pixel:=Mem[Vvga:(Y+I)*320+(X+J)]+Form1[i,j]+64;
      if pixel>=128 then pixel:=128;
      if pixel<=64 then pixel:=64;
      Mem[Vvga:(Y+I)*320+(X+J)]:=Pixel;
    End;
End;

Procedure Show;
const a=320; {218}
      xoff=160; {220}
      yoff=100; {100}
Var i,j   : integer;
    p     : Array[0..apoints,0..2] of Integer;
    x,y,z : real;
    Phi   : Longint;
    phi2 : longint;
Begin
  Phi:=0;
  phi2:=0;
  clear_page(Vvga);
  Repeat
      For i:=0 to apoints do Begin
        X:=Point[I,0]; Y:=Point[I,1]; Z:=Point[I,2];

        RotZ(X,Y,Phi mod 720);
        RotX(Y,Z,Phi mod 720);
        RotY(X,Z,Phi mod 720);

        P[I,0]:=Round(X*A/(Z-A))+160+Trunc(sintab[Phi2 mod 720]*77);
        P[I,1]:=Round(Y*A/(Z-A))+100+Trunc(sintab[(Phi2+180) mod 720]*20);
        if z=0 then z:=0.0001;

       drawblob(p[i,0],p[i,1],0)
      end;
    phi:=phi+2;
    inc(phi2,1);
    blur;
    Flip_pages(Vvga,$a000);
    Inc(fps);
  Until Keypressed;
end;

Procedure Init;
Var I : Integer;
    r,g,b : byte;
Begin
  for i:=0 to 63 do begin
    if i=0 then r:=0 else r:=trunc(63*exp(1   * ln(i/59)));
    if i=0 then g:=0 else g:=trunc(63*exp(7   * ln(i/55)));
    if i=0 then b:=0 else b:=trunc(63*exp(7   * ln(i/63)));
    if r>63 then r:=63; if g>63 then g:=63; if b>63 then b:=63;
    setpal(i,r,g,b);
    setpal(i+64,b,g,r);
  end;
  Fps:=1;
  GetMem(Vp1,64000); Vvga:=Seg(vp1^);
  clear_page(Vvga);
  For i:=0 to 720 do begin
      sintab[i]:=Sin(i*2*Pi/720) ;
      costab[i]:=Cos(i*2*Pi/720);
  end;
end;

BEGIN
  Set_Mode($13);
  Init;
  show;
  set_mode($3);
  freemem(vp1,64000);
END.