/* 2D Meta balls
 * Based on a text by Sebastien Loisel
 *
 * Let's hope this works
 */
#include <iostream.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>

const double PI = 3.14159265359;

const XDimension = 320;
const YDimension = 200;
const NumOfBalls = 3;

class MetaBall {
  public:
    float a,b,Radius;
    float da, db;

    void Init(void);
    float FindBall(int x, int y, float deler);
};

long XCache[320][320];
long YCache[200][200];
char screen_buff[64000];
float F[XDimension][YDimension];
MetaBall MBall[NumOfBalls];
char *screen = (char *)0x0a0000;
float STab[360], CTab[360];

void setpalette(char color, char red, char green, char blue)
{
        outp(0x3c8, color);
        outp(0x3c9, red);
        outp(0x3c9, green);
        outp(0x3c9, blue);
}

void initphongmap ( void )
{
    int FACE_RED     =   63;
    int FACE_GREEN   =   72;
    int FACE_BLUE    =   128;
    int LIGHT        =   350;
    int REFLECT      =   230;
    int AMBIENT      =   0;

    int i,j;
    float a,b;
    int x,y,temp1,temp2,temp3,loop;
    double intensity,nz,nx,ny;

	// create phong palette
	for ( loop = 0; loop < 256; loop ++ )
    {
        intensity = cos((255-loop)/512.0*PI);
        temp1 = FACE_RED * AMBIENT / 63.0 + FACE_RED * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp1 > 63 )
            temp1 = 63;
//        palette[loop*3] = temp1;
        temp2 = FACE_GREEN * AMBIENT / 63.0 + FACE_GREEN * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp2 > 63 )
            temp2 = 63;
//        palette[loop*3+1] = temp2;
        temp3 = FACE_BLUE * AMBIENT / 63.0 + FACE_BLUE * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp3 > 63 )
            temp3 = 63;
//        palette[loop*3+2] = temp3;
        setpalette(loop,temp1,temp2,temp3);
		}
}

void SetupTables(void)
{
  for (int i=0; i<360; i++) {
    STab[i]=sin(i/180.0*PI);
    CTab[i]=cos(i/180.0*PI); 
  }
}

void flipscreen(void);
#pragma aux flipscreen = \
                "mov edi,0a0000h"\
                "mov esi,offset screen_buff"\
                "mov ecx,16000"\
                "rep movsd"\
                modify [edi esi ecx];

void cls(void);
#pragma aux cls = \
                "mov edi,offset screen_buff"\
                "xor eax,eax"\
                "mov ecx,16000"\
                "rep stosd"\
                modify [edi eax ecx];

void SetMode(int n);
#pragma aux SetMode = \
  "int 0x10"\
  parm [eax]

void MetaBall::Init()
{
//  a=rand()%200+60; b=101.0; Radius = rand()%400+300;
//  da = sin(4./180.0*3.1415); //(160-a) / (100-b);
//  db = cos(1/180*3.1415); //1
}

float MetaBall::FindBall(int x, int y, float deler)
{
//  float f = Radius / (deler);
  float f = Radius / float((x-a)*(x-a)+(y-b)*(y-b));
  return f;
}

void RenderBalls( void )
{
  int x,y,i,j;
  char *pixel;
  char color;

  // set these to x++ and y++ for better image quality ...
  // + some changes to the pixel-plotting 
  for (x=0; x<XDimension; x+=2)
    for (y=0; y<YDimension; y+=2)
    {
      for (j=0; j<NumOfBalls; j++)
        F[x][y] += MBall[j].FindBall(x,y,1);

      pixel = &screen_buff[y*320+x];
      if (F[x][y]*20 < 255) 
        color = F[x][y]*20;
      else
        color = 255;

     // comment the lines starting from pixel++ to the last *pixel = color
     // together with setting x++ and y++ 
      if (F[x][y]>1) {
        *pixel = color;
        pixel++;
        *pixel = color;
        pixel+=319;
        *pixel = color;
        pixel++;
        *pixel = color;  
      }
    }
}

void UpdateBalls( int Phi )
{
  MBall[0].a = STab[Phi]*60+160; MBall[0].b = CTab[Phi]*40+100;
  MBall[1].a = STab[Phi]*40+160; MBall[1].b = STab[Phi]*50+100;
  MBall[2].a = CTab[Phi]*80+160; MBall[2].b = STab[(Phi+Phi)%360]*50+100;
}  

void ClearF( void )
{
  for (int x=0; x<XDimension; x++)
    for (int y=0; y<YDimension; y++)
      F[x][y] = 0;
}

void Setup( void )
{
  MBall[0].Radius = 20 * 20;
  MBall[1].Radius = 35 * 35;
  MBall[2].Radius = 25 * 25;

  for (int x=0; x<320; x++)
    for (int a=0; a<320; a++)
      XCache[x][a] = (x-a)*(x-a);

  for (int y=0; y<200; y++)
    for (int b=0; b<200; b++)
      YCache[y][b] = (y-b)*(y-b);
}

void Blur( void )
{
  int i,color;
  for (i=0; i<64000-320; i++) {
    color = screen_buff[i];
    color += screen_buff[i+1];
    color += screen_buff[i+319];
    color += screen_buff[i+320];
    color>>=2;
    screen[i]=color;
  }
}
void main(void)
{
  int Phi;

  SetMode(0x13);
  initphongmap();
//  for (Phi=0; Phi<255; Phi++)
//    setpalette(Phi,Phi/4,Phi/4,Phi/4);
  Setup();
  SetupTables();
  ClearF();

  do {
    Phi+=3;
    Phi%=360;
    RenderBalls();
//    flipscreen();
    Blur();
    cls();
    ClearF();
    UpdateBalls(Phi);
  } while (!kbhit());

  SetMode(3);
}
