/* LensFlare example by SilentBreed
 * This even works ! ( a bit )
 *
 * I know a better way to do lensflare, so things would look better.
 * But after i wrote this I didn't feel like implementing the other method.
 * It would be more of a 2D lensflare then.
 *
 * It's not difficult to implement this into your 3D-engine.
 * First check if something is blocking the ray between Origin and Direction,
 * (Check the values in the Z-buffer) If thats the case, only draw the
 * sunburst, else draw the whole lensflare.
 *
 * Oh yes, the I know the length thingy isn't correct either...
 * But it just has to suffise :)
 *
 * Alpha blending would've been nice :)
 *
 * I really needed OOP to complete this :)))) NOT
 * Laterz
 */

#include <ptc.h>

class Vector {
  public:
    float x,y,z;
};

class Lensflare {
  public:
    Vector Origin, Destination;

    void Show( void );
    void Init( void );
    void DeInit( void );
    void Update( void );
private:
    long *flares[5];
};

char *buffer;
int pitch;
float STab[256], CTab[256];

void SetupTables(void)
{
  for (int i=0; i<256; i++) {
    STab[i] = sin(double(i)/127*3.1415);
    CTab[i] = cos(double(i)/127*3.1415);
  }
}

void LoadFlare(char *FileName, long *Flare)
{
  FILE *f;
  char buf[3];
  
  f = fopen(FileName,"rb");
  for (int i=0; i<128*128; i++)
  {
      fread (&buf, sizeof(char), 3, f);
      Flare[i] = long(buf[2] | buf[1]<<8 | buf[0]<<16);
  }
  fclose(f);
}

void Lensflare::Init()
{
  Origin.x=0; Origin.y=0; Origin.z=-100;
  Destination.x=0; Destination.y=0; Destination.z=200;

  for (int i=0; i<4; i++)
    flares[i] = new long[128*128];

  LoadFlare("lens1.raw", flares[0]);
  LoadFlare("lens2.raw", flares[1]);
  LoadFlare("lens3.raw", flares[2]);
  LoadFlare("lens4.raw", flares[3]);
}

void Lensflare::DeInit()
{
  for (int i=0; i<4; i++)
    delete flares[i];
}

void DrawFlare(int x, int y,long *CurrentFlare)
{
  int I,J,X,Y,U,V;

  for (X=x-64; X<x+64;X++) 
    for (Y=y-64; Y<y+64; Y++) 
      if (X>0 && X<320 && Y>0 && Y<200) {
       uint *pixel = (uint *)(buffer+Y*pitch+X*4);
        U=X-x+64; V=Y-y+64;
        if (*pixel + CurrentFlare[V*128+U] > 0x00FFFFFF)
          *pixel = 0x00FFFFFF;
        else
          *pixel = (*pixel + CurrentFlare[V*128+U]) & 0xFFFFFFFF;
      }
}

void Lensflare::Show()
{
  const double Dist = 320;
  Vector Ray1;
  float OrigLength, Length, DeltaX, DeltaY, DeltaZ;
  int x,y;

  Length = OrigLength = fabs(Origin.z-Destination.z);

  DeltaX = (Destination.x-Origin.x) / Length;
  DeltaY = (Destination.y-Origin.y) / Length;
  DeltaZ = (Destination.z-Origin.z) / Length;

  Ray1 = Origin;
  do {
    x=(Ray1.x * Dist) / (Ray1.z + Dist) + 160;
    y=(Ray1.y * Dist) / (Ray1.z + Dist) + 100;

    if (Length==OrigLength)  
      DrawFlare(x,y,flares[0]);

    if (Length==int(OrigLength*0.7))
      DrawFlare(x,y,flares[1]);
 
    if (Length==int(OrigLength * 0.5)) 
      DrawFlare(x,y,flares[2]);
 
    if (Length==int(OrigLength * 0.2)) 
      DrawFlare(x,y,flares[3]);
 
    Length--;
    Ray1.x+=DeltaX; Ray1.y+=DeltaY; Ray1.z+=DeltaZ;
  } while (Length>=0);
}

void Lensflare::Update()
{
  static int Phi;
  Phi++;
  Phi&=255;
  Origin.x=int(CTab[Phi]*80);
  Origin.y=-40+int(STab[Phi]*10);

  Destination.x=-Origin.x*3;
  Destination.y=-Origin.y*3;
//  Destination.z=-Origin.z*2;
}

int main(int argc, char *argv[])
{
  Lensflare lensflare;

  PTC ptc(320,200,argc,argv);
  if (!ptc.ok())
  {
    if (!ptc.Init(320,200))
    {
      ptc.Error("could not initialize ptc");
      return 1;
    }
  }
    
  Surface surface(ptc,320,200,ARGB8888);
  if (!surface.ok())
  {
    ptc.Error("could not load image");
    return 1;
  }

  lensflare.Init();
  SetupTables();

  pitch = surface.GetPitch();
  do {
    buffer = (char *)surface.Lock();

    lensflare.Show();
    lensflare.Update();

    surface.Unlock();
    surface.Update();

    buffer=(char*)surface.Lock();
    if (buffer) for (int y=0; y<200; y++) memset(buffer+y*pitch,0,4*320);
    surface.Unlock(); 

  } while (!ptc.kbhit());

  lensflare.DeInit();
  ptc.Close();
  cout << "Another crappy example by SilentBreed." << endl;
  cout << "Contact me at   silentbreed@hotmail.com," << endl;
  cout << "or visit my web page at www.geocities.com/SiliconValley/Campus/4128/ " << endl;
  return 1;
}
