/*
  Easy demo-effect by SilentBreed
  Kinda old, but looks good
*/

#include "ptc.h"

const MAX_ANGLE    =   256;

double M_PI         =   3.14159265358979;

typedef long LightMap[256*256];

char bumpmap[64000];
signed int deltax[64000];
signed int deltay[64000];
int  sintab[MAX_ANGLE];
int  costab[MAX_ANGLE];

LightMap Purple, Red, Green;

void initphongmap ( LightMap LMap, char red, char green, char blue, float RadLimit )
{
    int FACE_RED     =   red;
    int FACE_GREEN   = green;
    int FACE_BLUE    =  blue;
    int LIGHT        =   27;//270
    int REFLECT      =    100; //320
    int AMBIENT      =    30;

    int i,j;
    float a,b;
    int x,y,temp1,temp2,temp3,loop;
    double intensity,nz,nx,ny;
    long phongpal[255];

    for ( loop = 0; loop < 256; loop ++ )
    {
        intensity = cos((255-loop)/512.0*M_PI);
        temp1 = FACE_RED * AMBIENT / 255.0 + FACE_RED * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp1 > 255 )
            temp1 = 255;
        temp2 = FACE_GREEN * AMBIENT / 255.0 + FACE_GREEN * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp2 > 255 )
            temp2 = 255;
        temp3 = FACE_BLUE * AMBIENT / 255.0 + FACE_BLUE * intensity + pow ( intensity, REFLECT ) * LIGHT;
        if ( temp3 > 255 )
            temp3 = 255;
        phongpal[loop]=temp3|(temp2<<8)|(temp1<<16);
    }
    // the above lines are from AZURE (slightly modified)

    for (i=0; i<=255; i++)
        for (j=0; j<=255; j++)
    {
        nx=(i-128.0)/128.0;
        ny=(j-128.0)/128.0;
        nz=1.0-sqrt(nx*nx+ny*ny)*RadLimit;
        if (nz<0) nz=0;
        LMap[i*256+j] = ((phongpal[char(nz*255.0)]) >> 1) & 0x7E7E7E7E;
    } 

}

void loadbumpmap (void)
{
    FILE *file;

    file=fopen("bumpmap.raw","rb");
    fread(bumpmap,sizeof(char),64000,file);
    fclose(file);
}

void calcdeltas (void)
{
    int x, y;

    for (y=0; y<200; y++)
        for (x=0; x<320; x++)
        {
            deltax[y*320+x]=bumpmap[y*320+x+1]-bumpmap[y*320+x-1];
            deltay[y*320+x]=bumpmap[(y+1)*320+x]-bumpmap[(y-1)*320+x];
        }
}

void dobumpmap (int Lx, int Ly, char *buffer, int pitch, LightMap LMap)
{
    int x,y,vlx,vly,nx,ny,col1,col2;

    for (y=2;y<198;y++)
        for (x=2; x<318; x++)
        {
            vlx=x-Lx;
            vly=y-Ly;
            nx=deltax[(y << 6)+ (y << 8) + x];
            ny=deltay[(y << 6)+ (y << 8) + x];         
            col1=128+(vlx-nx); if (col1<0 || col1>255) col1=0; 
            col2=128+(vly-ny); if (col2<0 || col2>255) col2=0;
            uint *pixel = (uint *)(buffer+pitch*y+x*4);
            if (*pixel+LMap[col1*256+col2] >= 0x00FFFFFF) {
              *pixel  = ((*pixel>>1)&0x7E7E7E7E) + ((LMap[col1*256+col2]>>1)&0x7E7E7E7E);
            } else {
              *pixel += LMap[col1*256+col2];
            }
        }
}

void inittables(void)
{
    int c;
    double i;
    i=0.0;
    for (c=0;c<MAX_ANGLE;c++,i++)
    {
        sintab[c]=int(sin(i/255.0*2.0*M_PI)*80);
        costab[c]=int(cos(i/255.0*2.0*M_PI)*70);
    }

}

int main( int argc, char *argv[])
{
    int i,x,y, Phi;

    loadbumpmap();
    calcdeltas();
    inittables();
    initphongmap( Red   , 205,   0,   0, 1.2 );
    initphongmap( Green ,  30, 205,  80, 1.7 );
    initphongmap( Purple,  25,  37, 187, 1.4 );


    PTC ptc(320,200,argc,argv);
    if (!ptc.ok())
    {
        if (!ptc.Init(320,200,VIRTUAL32))
        {
            ptc.Error("could not initialize ptc");
            return 1;
        }
    }
    
    Surface surface(ptc,320,200,ARGB8888);
    if (!surface.ok())
    {
        ptc.Error("could not load image");
        return 1;
    }

    do
    {
        int pitch=surface.GetPitch();
        char *buffer = (char*)surface.Lock();

        FORMAT format=surface.GetFormat();
        int bytes=surface.GetWidth()*format.bytes;
        int height=surface.GetHeight();
        if (buffer) for (y=0; y<height; y++) memset(buffer+y*pitch,0,bytes); 

        i+=2;
        Phi+=2;

        x = ( sintab[(i << 1) & 255] ) + 160;
        y = ( costab[i        & 255] ) + 100;
        dobumpmap ( x , y , buffer, pitch, Purple);
 
        x = ( costab[(i >> 1) & 255] ) + 160;
        y = ( sintab[(i  )    & 255] ) + 100;
        dobumpmap ( x , y , buffer, pitch, Red); 
                        
        x = ( costab[(i << 1) & 255] ) + 160;
        y = ( sintab[(i >> 1) & 255] ) + 100;
        dobumpmap ( x , y , buffer, pitch, Green);

        surface.Unlock();
        surface.Update();
    }while(!ptc.kbhit());
    ptc.Close();

    cout << "Bumpmapping example by SilentBreed" << endl;
    cout << "contact my at silentbreed@hotmail.com or check out my website." << endl;
    return 0;
}
