/****************************************************************************
 spline_3.c, ver 1.3 (08/07/1997) from "Exploring 3DS secrets" series :)
 ----------------------------------------------------------------------------
 Written by Timur Davidenko (aka Adept/Esteem), 1997.
 Send any comments/suggestions to: adept@aquanet.co.il
 I`ll be glad to see any responses.
 ----------------------------------------------------------------------------
 This file contain C source code for interpolating spline used by
 3D studio, including all spline controls parameters.
 I`ve been looking for this formuls for more then half year,and i belive
 still many people will be very glad to know them,thats why i releasing
 this source. It not optimized for speed or anything else i tried to keep
 it as clear as posible.

 Big thanks to Torgeir Hagland (aka Xanthome),
	Javier Arevalo (aka Jare/Iguana,VOR and RexDeathscar/Waterlogic
	for great support on topic.

 I compile this source with Borland C/C++ 3.1,it shouldn`t be a a problem
 to compile with other AnsiC compiler, it only require standart graphics
 library to be linked and egavga.bgi file to be present in same directory.
 ----------------------------------------------------------------------------
 Tech notes:
		It is Kochanek-Bartels spline sub-type of hermit curve developped
		espesially for computer key animations,first presented at SIGGRAPH'84.
		Basic derivatives and ease calculation function derrived from
		3D Studio and Lightwave technical documents.
		Quaternion exponent/logarithm functions and 3 slerps interpolation
		debugged out of 3DS by Torgeir Hagland (aka Xanthome).

		Basic hermit curve evaluted as follow:
				.
					o  P1(x,y,z), R1(x,y,z)="departing derivative"
					.	\
					 .	\
						.		\
						 .		\
							 . . .o P4(x,y,z), R4(x,y,z)="arriving derivative"

(1)	X(t) = T * M * G
		where:
			B - Hermit Basis Matrix.
			G - Hermit Geometry Matrix.
			T - Time matrix.

			                            
			  2 -2  1  1            P1x 
	M =  -3  3 -2 -1      G =   P4x    T = [ t^3 t^2 t 1]
			  0  0  1  0            R1x 
			  1  0  0  0            R4x 
			             					      

		P1 and P4 are end points of spline segment while R1 and R4 thier
		respective tangent vectors	(derivatives)

		Another way to write the hermite spline equations is as	a
		Blending Function. This is really just the multiplied-out results
		of the above matrix equation, and looks like this:

(2)	X(t) = 	( 2t3 - 3t2 + 1)*P1x +
						(-2t3 + 3t2    )*P4x +
						(  t3 - 2t2 + t)*R1x +
						(  t3 - t2     )*R4x

		When continuity,bias and tension slope controls appears
		derivatives (for X) calculated like this:

		pkey 	- previous key.
		key		- current key
		nkey 	- next key.
		ds 		- source derivative.
		dd 		- destination derivative.

		dsA = (1.0 - key.tens) * (1.0 - key.cont) * (1.0 + key.bias);
		dsB = (1.0 - key.tens) * (1.0 + key.cont) * (1.0 - key.bias);
		dsAdjust = (key.frame - prevkey.frame)/(nextkey.frame - prevkey.frame)
		ds = dsAdjust * ( dsA*(key.x - prevkey.x) + dsB*(nextkey.x - key.x) )

		ddA = (1.0 - key.tens) * (1.0 + key.cont) * (1.0 + key.bias);
		ddB = (1.0 - key.tens) * (1.0 - key.cont) * (1.0 - key.bias);
		ddAdjust = (nextkey.frame - key.frame)/(nextkey.frame - prevkey.frame)
		dd = ddAdjust * ( ddA*(key.x - prevkey.x) + ddB*(nextkey.x - key.x) )

		Insert key`s position and ds,dd values to equation (2) and congrads!
		u have interpolated spline :)

		I`ve a real pain figuring out myself formuls for calculating
		derivatives at first/last key of spline (3DS calculate them differently)
		I tested them almost in all	imagenable cases and they provided 100%
		correct	result but still if	you will find they give wrong results
		for some specific case plz let me know of that.

 ----------------------------------------------------------------------------
 Known bugs:
		When more then 2 keys in rotation track,interpolation between quaternions
		with angle more then 360 degrees not produce exactly same result as 3DS
		(although it close).
 ----------------------------------------------------------------------------
 PS.
		Look also for 3dsrdr.c 3ds files reader by Javier Arevalo (Jare/Iguana)
		and 3DSCO20.ZIP by Mats Byggmastar (Mri/Doomsday) for great examples
		of reading .3DS files.
		Make sure you check "Clax" 3DS reader/keyframer engine by Borzom.
 ----------------------------------------------------------------------------
																DISCALIMER
 I can not be held responsible for any damages this source may produce,
 Use it on your own risk.
 You are free to distribute,copy,use and modify this source code with one
 restriction do not distribute modified copy of this source without firstly
 asking me for permission.
****************************************************************************/

#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
//#include "math3d.h"	// In project include math3d.h
#include "math3d.c"

// Global key structure, position key don`t need many of this fields.
typedef	struct	{
	float	frame;				// Key frame.
	Quat 	pos;					// Position vector (quaternion).
	Quat 	ds,dd;				// Key derivatives.
	Quat 	angleaxis;	 	// Quaternion in angle/axis.
	float	tens;					// Key tension value.
	float	cont;					// Key continuity value.
	float bias;					// Key bias value.
	float easeto;				// Key ease to value.
	float easefrom;			// Key ease from value.
}		Key;

static	Key keys[100];

static	int	MAX;								// Max used keys.
static	int	LAST;								// Last used key.

static	int	trackLOOP=0;				 // Loop track.
static	int	trackREPEAT=0;			 // Repeat track.

float Ease( float t, float a, float b)	{
	float k;
	float s = a+b;

	if (s == 0.0) return t;
	if (s > 1.0) {
		a = a/s;
		b = b/s;
	}
	k = 1.0/(2.0-a-b);
	if (t < a) return ((k/a)*t*t);
	else	{
		if (t < 1.0-b)	{
			return (k*(2*t - a));
		}	else {
			t = 1.0-t;
			return (1.0-(k/b)*t*t);
		}
	}
}

/*---------------------------------------------------------------------------
 This computes the derivative at key, as a weighted average of the linear
 slopes into and out of key, the weights being determined by the tension and
 continuity parameters.
 Actually two derivatives are computed at key:
				"ds" is the "source derivative", or "arriving derivative"
				"dd" is the "destination derivative" or "departing derivative"
---------------------------------------------------------------------------*/
void	CompDeriv( Key *prevkey,Key *key,Key *nextkey )	{
	float dsA,dsB,ddA,ddB,dsAdjust,ddAdjust;
	float v1,v2;
	float pf,f,nf;

	pf = prevkey->frame;
	f =  key->frame;
	nf = nextkey->frame;
	if (pf > f)	{			// if track have LOOP flag.
		f += keys[LAST].frame;
		nf += keys[LAST].frame;
	} else
	if (f > nf)	{
		nf += keys[LAST].frame;
	}
	dsA = (1.0 - key->tens) * (1.0 - key->cont) * (1.0 + key->bias);
	dsB = (1.0 - key->tens) * (1.0 + key->cont) * (1.0 - key->bias);
	dsAdjust = (f - pf)/(nf - pf);

	ddA = (1.0 - key->tens) * (1.0 + key->cont) * (1.0 + key->bias);
	ddB = (1.0 - key->tens) * (1.0 - key->cont) * (1.0 - key->bias);
	ddAdjust = (nf - f)/(nf - pf);

	// X derivative.
	v1 = key->pos.x - prevkey->pos.x;
	v2 = nextkey->pos.x - key->pos.x;
	key->ds.x = dsAdjust*( dsA*v1 + dsB*v2 );
	key->dd.x = ddAdjust*( ddA*v1 + ddB*v2 );

	// Y derivative.
	v1 = key->pos.y - prevkey->pos.y;
	v2 = nextkey->pos.y - key->pos.y;
	key->ds.y = dsAdjust*( dsA*v1 + dsB*v2 );
	key->dd.y = ddAdjust*( ddA*v1 + ddB*v2 );

	// Z derivative.
	v1 = key->pos.z - prevkey->pos.z;
	v2 = nextkey->pos.z - key->pos.z;
	key->ds.z = dsAdjust*( dsA*v1 + dsB*v2 );
	key->dd.z = ddAdjust*( ddA*v1 + ddB*v2 );
}

void	CompDerivFirst( Key *key,Key *keyn,Key *keynn )	{
	float	f20,f10,v20,v10;
	f20 = keynn->frame - key->frame;
	f10 = keyn->frame - key->frame;

	v20 = keynn->pos.x - key->pos.x;
	v10 = keyn->pos.x - key->pos.x;
	key->dd.x = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);

	v20 = keynn->pos.y - key->pos.y;
	v10 = keyn->pos.y - key->pos.y;
	key->dd.y = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);

	v20 = keynn->pos.z - key->pos.z;
	v10 = keyn->pos.z - key->pos.z;
	key->dd.z = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);
}

void	CompDerivLast( Key *keypp,Key *keyp,Key *key )	{
	float	f20,f10,v20,v10;
	f20 = key->frame - keypp->frame;
	f10 = key->frame - keyp->frame;

	v20 = key->pos.x - keypp->pos.x;
	v10 = key->pos.x - keyp->pos.x;
	key->ds.x = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);

	v20 = key->pos.y - keypp->pos.y;
	v10 = key->pos.y - keyp->pos.y;
	key->ds.y = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);

	v20 = key->pos.z - keypp->pos.z;
	v10 = key->pos.z - keyp->pos.z;
	key->ds.z = (1-key->tens)*(v20*(0.25 - f10/(2*f20)) + (v10 - v20/2)*3/2 + v20/2);
}

void	CompDerivFirst2( Key *key,Key *keyn )	{
	float	v;
	v = keyn->pos.x - key->pos.x;
	key->dd.x = v*(1-key->tens);

	v = keyn->pos.y - key->pos.y;
	key->dd.y = v*(1-key->tens);

	v = keyn->pos.z - key->pos.z;
	key->dd.z = v*(1-key->tens);
}

void	CompDerivLast2( Key *keyp,Key *key )	{
	float	v;
	v = key->pos.x - keyp->pos.x;
	key->ds.x = v*(1-key->tens);

	v = key->pos.y - keyp->pos.y;
	key->ds.y = v*(1-key->tens);

	v = key->pos.z - keyp->pos.z;
	key->ds.z = v*(1-key->tens);
}

static int CompAB( Key *prev, Key *cur, Key *next )
{
	int i;
	Quat qprev,qnext,q,qzero;
	Quat qp,qm,qa,qb,qae,qbe;
	float tm,cm,cp,bm,bp,tmcm,tmcp,ksm,ksp,kdm,kdp,c;
	float dt,fp,fn;

	if( prev != NULL ) {
		if (fabs(cur->angleaxis.w - prev->angleaxis.w) > 2*M_PI-.00001) {
			q = cur->angleaxis;
			q.w = 0;
			qlog( q,&qm );
		} else {
			qprev = prev->pos;
			if (qdotunit( qprev,cur->pos ) < 0) qnegate( &qprev );
			qlndif( qprev, cur->pos, &qm );
		}
	}

	if( next != NULL ) {
		if( fabs(next->angleaxis.w - cur->angleaxis.w) > 2*M_PI-.00001 ) {
			q = next->angleaxis;
			q.w = 0;
			qlog( q, &qp );
		} else {
			qnext = next->pos;
			if (qdotunit( qnext,cur->pos ) < 0) qnegate( &qnext );
			qlndif( cur->pos, qnext, &qp );
		}
	}

	if( prev == NULL ) qm = qp;
	if( next == NULL ) qp = qm;

	fp = fn = 1.0;
	cm = 1.0 - cur->cont;

	if( prev && next ) {
		dt = 0.5 * (float)(next->frame - prev->frame );
		fp = ((float)(cur->frame - prev->frame))/dt;
		fn = ((float)(next->frame - cur->frame))/dt;
		c = fabs( cur->cont );
		fp = fp + c - c * fp;
		fn = fn + c - c * fn;
	}
	tm = .5*(1.0 - cur->tens);
	cp = 2.0 - cm;
	bm = 1.0 - cur->bias;
	bp = 2.0 - bm;
	tmcm = tm * cm;
	tmcp = tm * cp;
	ksm  = 1.0 - tmcm * bp * fp;
	ksp  = -tmcp * bm * fp;
	kdm  = tmcp * bp * fn;
	kdp  = tmcm * bm * fn - 1.0;

	qa.x = .5 * ( kdm * qm.x + kdp * qp.x );
	qb.x = .5 * ( ksm * qm.x + ksp * qp.x );

	qa.y = .5 * ( kdm * qm.y + kdp * qp.y );
	qb.y = .5 * ( ksm * qm.y + ksp * qp.y );

	qa.z = .5 * ( kdm * qm.z + kdp * qp.z );
	qb.z = .5 * ( ksm * qm.z + ksp * qp.z );

	qa.w = .5 * ( kdm * qm.w + kdp * qp.w );
	qb.w = .5 * ( ksm * qm.w + ksp * qp.w );

	qexp( qa, &qae );
	qexp( qb, &qbe );

	qmul( cur->pos, qae, &cur->ds );
	qmul( cur->pos, qbe, &cur->dd );

	return 0;
}

void	calcPositionDerivs()	{
	int n;

	if (MAX > 2)	{
		for (n = 1; n < LAST; n++ )	{
			CompDeriv( &keys[n-1],&keys[n],&keys[n+1] );
		}
		if (trackLOOP)	{
			CompDeriv( &keys[LAST-1],&keys[0],&keys[1] );
			CompDeriv( &keys[LAST-1],&keys[LAST],&keys[1] );
		}	else	{
			CompDerivFirst( &keys[0],&keys[1],&keys[2] );
			CompDerivLast( &keys[LAST-2],&keys[LAST-1],&keys[LAST] );
		}
		// if track have Loop option set then
		// 1) keys[0] == keys[LAST]
		//		CompDeriv( &keys[LAST-1],&keys[0],&keys[1] );
		//		CompDeriv( &keys[LAST-1],&keys[LAST],&keys[1] );
		// 2) CompDeriv function should be updated to propertly  handle
		//		frames difference in 2 above equations (inside CompDeriv
		//		should be: (prev->frame < curr->frame < next->frame).
		// For repeat track derrivates are regular all u need is to take
		// modul of time by key[LAST]->frame.
		// Same goes to quaternions...
	} else	{
		CompDerivFirst2( &keys[0],&keys[1] );
		CompDerivLast2( &keys[0],&keys[1] );
	}
}

void	calcQuaternionDerivs()	{
	int n;

	if (MAX > 2)	{
		for (n = 1; n < LAST; n++ )	{
			CompAB( &keys[n-1],&keys[n],&keys[n+1] );
		}
	}
	CompAB( NULL,&keys[0],&keys[1] );
	CompAB( &keys[0],&keys[LAST],NULL );
}


// Draw Kochanek-Bartels spline.
void	Draw3DSSpline()	{
	int	i,n;
	float	j,t,t2,t3,frames;
	float	x,y,z;
	float h[4];

	calcPositionDerivs();	// Calculate derivatives.

	for (n = 0; n < LAST; n++ )	{
		line( keys[n].pos.x,480-keys[n].pos.y,
					keys[n+1].pos.x,480-keys[n+1].pos.y );	// test line.

		frames = keys[n+1].frame - keys[n].frame;
		for (j = 0; j <= frames; j++)	{
			t = j/frames;
			t = Ease( t,keys[n].easefrom,keys[n+1].easeto );
			t2 = t*t;												// t2 = t^2;
			t3 = t2*t;											// t3 = t^3;

			h[0] = 2*t3 - 3*t2 + 1;
			h[1] = -2*t3 + 3*t2;
			h[2] = t3 - 2*t2 + t;
			h[3] = t3 - t2;

			x = (h[0]*keys[n].pos.x) + (h[1]*keys[n+1].pos.x) +
					(h[2]*keys[n].dd.x) + (h[3]*keys[n+1].ds.x);
			y = (h[0]*keys[n].pos.y) + (h[1]*keys[n+1].pos.y) +
					(h[2]*keys[n].dd.y)	+	(h[3]*keys[n+1].ds.y);
			z = (h[0]*keys[n].pos.z) + (h[1]*keys[n+1].pos.z) +
					(h[2]*keys[n].dd.z)	+	(h[3]*keys[n+1].ds.z);

			putpixel( x,480-y,13 );
		}
	}
}

//	Time should be: 0 < time < LastFrame.
//	Derivatives must be calculated before calling this.
void	getPosition( float time, float *x,float *y,float *z )	{
	int	i,n;
	float	j,t,t2,t3,frames;
	float h[4];

	if (trackLOOP || trackREPEAT)
		time = keys[0].frame + fmod( time,keys[LAST].frame - keys[0].frame );

	if (time < keys[0].frame)	{
		*x = keys[0].pos.x;
		*y = keys[0].pos.y;
		*z = keys[0].pos.z;
		return;
	} else
	if (time > keys[LAST].frame)	{
		*x = keys[LAST].pos.x;
		*y = keys[LAST].pos.y;
		*z = keys[LAST].pos.z;
		return;
	}

	n = 0;
	while ((n < LAST)&&(keys[n+1].frame < time))	n++;

	frames = keys[n+1].frame - keys[n].frame;
	t = (time - keys[n].frame)/frames;
	t = Ease( t,keys[n].easefrom,keys[n+1].easeto );
	t2 = t*t;												// t2 = t^2;
	t3 = t2*t;											// t3 = t^3;

	h[0] = 2*t3 - 3*t2 + 1;
	h[1] = -2*t3 + 3*t2;
	h[2] = t3 - 2*t2 + t;
	h[3] = t3 - t2;

	*x = (h[0]*keys[n].pos.x) + (h[1]*keys[n+1].pos.x) +
			(h[2]*keys[n].dd.x) + (h[3]*keys[n+1].ds.x);
	*y = (h[0]*keys[n].pos.y) + (h[1]*keys[n+1].pos.y) +
			(h[2]*keys[n].dd.y)	+	(h[3]*keys[n+1].ds.y);
	*z = (h[0]*keys[n].pos.z) + (h[1]*keys[n+1].pos.z) +
			(h[2]*keys[n].dd.z)	+	(h[3]*keys[n+1].ds.z);
}

void	InterpolateQuaternion()	{
	int	i,n;
	float	j,time,frames,spin,angle;
	Quat p,q,q1;
	Matrix	m;

	calcQuaternionDerivs();

	for (n = 0; n < LAST; n++ )	{
		frames = keys[n+1].frame - keys[n].frame;
		for (j = 0; j < frames; j++)	{
			time = j/frames;
			time = Ease( time,keys[n].easefrom,keys[n+1].easeto );

			angle = (keys[n+1].angleaxis.w - keys[n].angleaxis.w);
			if (angle > 0)
				spin = floor( angle/(2*M_PI) );
			else
				spin = ceil( angle/(2*M_PI) );
			angle = angle - (2*M_PI)*spin;

			if (fabs(angle) > M_PI)	{
				qslerplong( keys[n].pos,keys[n+1].pos,&p,time,spin );
				qslerplong( keys[n].dd,keys[n+1].ds,&q,time,spin );
				time = (((1.0-time)*2.0)*time);
				qslerplong( p,q,&q1,time,0 );
			}	else	{
				qslerp( keys[n].pos,keys[n+1].pos,&p,time,spin );
				qslerp( keys[n].dd,keys[n+1].ds,&q,time,spin );
				time = (((1.0-time)*2.0)*time);
				qslerp( p,q,&q1,time,0 );
			}

			quat2inverseMatrix( q1,&m );

			// Here u get ready matrix m.
			putpixel( 0,480,13 );	// just for test...
		}
	}
}

// Set position key.
void	SetKey( Key *key,	float frame,
							float x,float y,float z,
							float t,float c,float b,float eto,float efrom )	{
	key->frame = frame;
	key->pos.x = x;
	key->pos.y = y;
	key->pos.z = z;
	key->pos.w = 0;
	key->tens = t;
	key->cont = c;
	key->bias = b;
	key->easeto = eto;
	key->easefrom = efrom;
	key->ds.x = 0; key->ds.y = 0; key->ds.z = 0;
	key->dd.x = 0; key->dd.y = 0; key->dd.z = 0;
}

// Set rotation key. (input quaternion in angle/axis form)
void	SetRotKey( Key *key,	float frame,
							float x,float y,float z,float w,
							float t,float c,float b,float eto,float efrom )	{
	float s;
	// Only for test! 3DS file contain angle value in radians already.
	w *= M_PI/180.0;	// convert angle to radians.
	key->frame = frame;
	key->angleaxis.w = w;
	key->angleaxis.x = x;
	key->angleaxis.y = y;
	key->angleaxis.z = z;
	s = sin(w/2);
	key->pos.x = x*s;
	key->pos.y = y*s;
	key->pos.z = z*s;
	key->pos.w = cos(w/2);
	key->tens = t;
	key->cont = c;
	key->bias = b;
	key->easeto = eto;
	key->easefrom = efrom;
	key->ds.x = 0; key->ds.y = 0; key->ds.z = 0; key->ds.w = 0;
	key->dd.x = 0; key->dd.y = 0; key->dd.z = 0; key->ds.w = 0;
}

void	InitKeys()	{
	// Table of tens/bias/cont equialents.
	// Value in 3DStudio key info: |  0 | 25 | 50 |
	// Value for SetKey:           | -1 |  0 |  1 |

	// Table of easeto/easefrom equialents.
	// Value in 3DStudio key info: |  0 | 50 |
	// Value for SetKey:           |  0 |  1 |

	//							 Frm.  X   Y   Z  t  c  b  et ef
	SetKey( &keys[0],0,		100,100, 0, 0, 0, 0, 0, 0 );
	SetKey( &keys[1],50,	250,300, 0, 0, 0, 0, 0, 0 );
	SetKey( &keys[2],100,	400,200, 0, 0, 0, 0, 0, 0 );
	SetKey( &keys[3],150,	550,250, 0, 0, 0, 0, 0, 0 );
	MAX = 4;
	LAST = MAX-1;
}

void	InitRotKeys()	{
	//                 Frm.  X   Y   Z  W,  t  c  b  et ef
	SetRotKey( &keys[0],0,   1,  0,  0, 0,  0, 0, 0, 0, 0 );
	SetRotKey( &keys[1],20,  0,  1,  0, 90, 0, 0, 0, 0, 0 );
	SetRotKey( &keys[2],40,  0,  1,  0, 180,0, 0, 0, 0, 0 );
	SetRotKey( &keys[3],60,  0,  1,  0, 90, 0, 0, 0, 0, 0 );

//	Gives not exactly correct results :((
//	SetRotKey( &keys[0],0,   1,  0,  0, 0,  0, 0, 0, 0, 0 );
//	SetRotKey( &keys[1],40,  0,  1,  0, 400, 0, 0, 0, 0, 0 );
//	SetRotKey( &keys[2],60,  0,  1,  0, 700, 0, 0, 0, 0, 0 );

	MAX = 4;
	LAST = MAX-1;
}

int main(void)
{
	 /* request auto detection */
	 int gdriver = DETECT, gmode, errorcode;
	 initgraph(&gdriver, &gmode, "\\BC\\BGI" );
	 errorcode = graphresult();
	 if (errorcode != grOk)  /* an error occurred */
	 {
			printf("Graphics error: %s\n", grapherrormsg(errorcode));
			printf("Press any key to halt:");
			getch();
			exit(1);             /* return with error code */
	 }

	InitKeys();
	Draw3DSSpline();

	InitRotKeys();
	InterpolateQuaternion();

	getch();
	closegraph();
	return 0;
}