#include <ptc.h>

const double PI = 3.14159265359;
const Step = 4;

char *buffer;
int pitch;
long CTab[360],STab[360];
long Texture[256*256];
long Texture2[256*256];
struct {
  float u,v;
} Grid[320][200];

void OpenTexture ( void )
{
  FILE *file;
  char buf[3];
  file = fopen("texture.raw","rb");
  for (int i=0; i<256*256; i++)
  {
      fread (&buf, sizeof(char), 3, file);
      Texture[i] = buf[2] | buf[1]<<8 | buf[0]<<16;
  }
  fclose(file);
  file = fopen("texture1.raw","rb");
  for (i=0; i<256*256; i++)
  {
      fread (&buf, sizeof(char), 3, file);
      Texture2[i] = buf[2] | buf[1]<<8 | buf[0]<<16;
  }
  fclose(file);
}

void SetupTables(void)
{
  for (int i=0; i<360; i++) {
    STab[i]=long(sin(i/180.0*PI)*65536.0);
    CTab[i]=long(cos(i/180.0*PI)*65536.0); 
  }
}

void Interpolate( void )
{
  int x,y,i,j;
  float dul,dur,dvl,dvr,du,dv,ul,ur,vl,vr,u,v;

  for (j=0; j<200; j+=Step)
    for (i=0; i<320; i+=Step) {
      dul = (Grid[i][j+Step].u - Grid[i][j].u) / Step;
      dur = (Grid[i+Step][j+Step].u - Grid[i+Step][j].u) / Step;
      dvl = (Grid[i][j+Step].v - Grid[i][j].v) / Step;
      dvr = (Grid[i+Step][j+Step].v - Grid[i+Step][j].v) / Step;
      ul = Grid[i][j].u; ur = Grid[i+Step][j].u;
      vl = Grid[i][j].v; vr = Grid[i+Step][j].v;
      for (y=j; y<j+Step; y++) {
        du = (ur - ul) / Step;
        dv = (vr - vl) / Step;
        u = ul; v = vl;
        for (x=i; x<i+Step; x++) {
          uint *pixel = (uint *)(buffer + y*pitch +x*4);
          *pixel = Texture[char(v)*256+char(u)];
          u+=du;
          v+=dv;
        }
        ul += dul; ur += dur;
        vl += dvl; vr += dvr;
      }
    }
}

void DoZoom(int Phi)
{
  int x,y,x2,y2;
  char u,v;
  char u2,v2;

  uint *pixel = (uint *)(buffer);
  for (y=0; y<200; y++) {
    for (x=0; x<320; x++) {
      u = ((x*CTab[Phi] - y*STab[Phi]) >> 16 ) * STab[Phi]*4 >> 16;
      v = ((x*STab[Phi] + y*CTab[Phi]) >> 16 ) * STab[Phi]*4 >> 16;
      u2 = ((x*STab[Phi] - y*CTab[Phi]) >> 16 ) * -STab[Phi]*2 >> 16;
      v2 = ((x*CTab[Phi] + y*STab[Phi]) >> 16 ) * -STab[Phi]*2 >> 16;
      *pixel = ((Texture[v*256+u] >> 1) & 0x7E7E7E7E) + ((Texture2[u2*256+v2] >> 1) & 0x7E7E7E7E);
      pixel++;
//      Grid[x][y].u = float(u); Grid[x][y].v = float(v);
    }
  }
}

int main ( int argc, char *argv[] )
{
  int Phi = 0;
  clock_t t1,t2;
  
  SetupTables();
  OpenTexture();
  PTC ptc(320,200,argc,argv);
  if (!ptc.ok()) {
    if (!ptc.Init(320,200)) {
      ptc.Error("Error initializing video mode");
      return -1;
    }
  }
  Surface surface(ptc,320,200,ARGB8888);
  if (!surface.ok()) {
    ptc.Error("Could not load image");
    return -1;
  }

  pitch = surface.GetPitch();
  buffer = (char *)surface.Lock();

  int frames = 0;
  t1 = clock();
  do {
    Phi++;
    Phi %= 360;
    DoZoom(Phi);
//    Interpolate();

    surface.Unlock();
    surface.Update();
    frames++;
  } while (!ptc.kbhit());
  t2 = clock();
  ptc.Close();
  cout << "frames : " << frames << endl;
  cout << "fps    :" << frames / ((t2-t1) / float(CLK_TCK)) << endl; 
  return 1;
}
