#include <iostream.h>
#include "quat.h"

main()
{
  Quaternion First(1,2,3,4);
  cout << "My first Quaternion: " << First << endl;

  Quaternion Second(2,1,4);
  cout << "My second Quaternion: " << Second << endl;
  cout << "The product of both Quaternions: " << First*Second << endl;

  Quaternion q(20);

  cout << "Product of " << (Quaternion)30 << " and " << q << "  =  " << 30*q << endl << endl;


  // demonstrate slerp
  Quaternion a(0.5, 10, 13, 2);
  Quaternion b(15, 666.333, 12.1, 22.12);
  Quaternion result;
  // calculate position in the middle of both quaternions ( t = 0.5 )
  result.Slerp(a, b, 0.5);
  cout << "Interpolated Quaternion is: " << result << endl << endl;

  cout << "A Quaternion describing a rotation of a 90 Angle around the (1, 0, 0) axis: " << endl;
  a.FromAxis(90.0*PI/180, 1.0, 0, 0);
  cout << a << endl;
  cout << "Exponent of this Quaternion: " << a.exp() << endl << endl;

  cout << "Conjugate of Quaternion " << First << " : " << ~First << endl;
  cout << "Inverse of Quaternion " << Second << ": ";
  cout << -Second << endl;
}

