// Fixed Point Math
// ================
// This code was written 100% by me personally.  It's nothing really special
// but it makes things fairly simple.  It's very easy to understand and speeds
// things up tremendously compared to floating point.
//
// Scott A. Deming
// sad@umcc.umich.edu

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <time.h>
#include <math.h>

#include "gfxmath.h"

long    cosTab[256];
long    sinTab[256];

int     yTab[200];

long    scaleTab[128];

void    gfxInitTables()
{
    int     i;
    float   scale;

    // Initialize (co)sin table.  256 degrees.
    for (i=0; i<256; i++) {
        cosTab[i] = cos((6.28/256)*i)*1024;
        sinTab[i] = sin((6.28/256)*i)*1024;
    }

    // Initialize y offset table.
    for (i=0; i<200; i++) {
        yTab[i] = i*320;
    }

    scale = 1.0/64.0;
    for (i=0; i<128; i++) {
        scaleTab[i] = scale*1024;
        scale += 1.0/64.0;
    }
}
