; Falcon demoshell
; February 6, 2000
;
; Average FramesPerSecond performance
;
; Anders Eriksson
; ae@dhs.nu
;
; fps.s


; --------------------------------------------------------------
		section	text
; --------------------------------------------------------------

fps_print:	move.l	#.app,d0				;*.app
		bsr.s	.search					;
		tst.l	d0					;
		beq.w	.gem					;

		move.l	#.prg,d0				;*.prg
		bsr.s	.search					;
		tst.l	d0					;
		beq.w	.gem					;

		move.l	#.gtp,d0				;*.gtp
		bsr.s	.search					;
		tst.l	d0					;
		beq.w	.gem					;

.tos:		move.l	#fps_text,fps_adr			;addr
		bsr.s	.calculate				;hex>char
		bsr.w	fps_print_tos				;print
		rts						;

.gem:		move.l	#fps_alert+4,fps_adr			;addr
		bsr.s	.calculate				;hex>char
		bsr.w	fps_print_gem				;print
		rts						;

.search:	move.w	#0,-(sp)				;fsfirst() get fileinfo
		move.l	d0,-(sp)				;
		move.w	#$4e,-(sp)				;
		trap	#1					;
		addq.l	#8,sp					;
		rts

.app:		dc.b	'*.app',0				;app
		even						
.prg:		dc.b	'*.prg',0				;prg
		even
.gtp:		dc.b	'*.gtp',0				;gtp
		even

.calculate:
		clr.l	d1					;100Hz ticks made
		move.w	fps_run,d1				;
		divu.w	#100,d1					;make seconds
		
		clr.l	d0					;updates made
		move.w	fps_updated,d0				;
		
		divu.w	d1,d0					;fps

		move.l	fps_adr,a0				;output
		lea.l	fps_table,a1				;chartable

		and.l	#$0000ffff,d0				;convert hex>char
		divu.w	#100,d0					;
		move.b	(a1,d0.w),(a0)+				;

		clr.w	d0					;
		swap	d0					;
		divu.w	#10,d0					;
		move.b	(a1,d0.w),(a0)+				;

		swap	d0					;
		move.b	(a1,d0.w),(a0)+				;

		rts


fps_print_tos:	move.l	#fps_text,d0				;print fps
		bsr.w	cconws					;
		bsr.w	crawcin	
		rts


fps_print_gem:	lea.l	fps_control,a0				;aes control structure
		move.w	#$a,(a0)+				;+0 appl_init()
		clr.w	(a0)+					;+2 int_in parameters
		move.w	#1,(a0)+				;+4 int_out parameter
		clr.w	(a0)+					;+6 addr_in parameters
		clr.w	(a0)					;+8 addr_out paramters
		bsr.w	.aes					;call aes

		lea.l	fps_control,a0				;aes control structure
		move.w	#$4d,(a0)+				;+0 graf_handle()
		clr.w	(a0)+					;+2 int_in parameters
		move.w	#5,(a0)+				;+4 int_out parameters
		clr.w	(a0)+					;+6 addr_in parameters
		clr.w	(a0)					;+8 addr_out parameters
		bsr.w	.aes					;call aes

		lea.l	fps_control,a0				;aes control structure
		move.w	#$34,(a0)+				;+0 form_alert()
		move.w	#1,(a0)+				;+2 
		move.w	#1,(a0)+				;+4
		move.w	#1,(a0)+				;+6
		clr.w	(a0)					;+8
		clr.w	fps_int_in				;prefered button for enter (0=none 1=leftmost 2=middle 3=rightmost)
		move.l	#fps_alert,fps_addr_in			;address to alert structure
		bsr.w	.aes					;call aes

		lea.l	fps_control,a0				;aes control structure
		move.w	#$13,(a0)+				;+0 appl_exit()
		clr.w	(a0)+					;+2 int_in parameters
		move.w	#1,(a0)+				;+4 int_out parameters
		clr.w	(a0)+					;+6 addr_in parameters
		clr.w	(a0)					;+8 addr_out parameters
		bsr.w	.aes					;call aes

		rts

.aes:		move.l	#fps_aes_pb,d1				;call aes
		move.w	#200,d0					;
		trap	#2					;
		rts


; --------------------------------------------------------------
		section	data
; --------------------------------------------------------------

fps_table:	dc.b	'0123456789'
		even

fps_text:	dc.b	'    fps in average.',13,10,0
		even

fps_alert:	dc.b	'[1][    fps in average.][Coolness!]',0
		even

fps_adr:	dc.l	fps_text

fps_aes_pb:	dc.l	fps_control,fps_global,fps_int_in
		dc.l	fps_int_out,fps_addr_in,fps_addr_out

; --------------------------------------------------------------
		section	bss
; --------------------------------------------------------------

fps_run:	ds.w	1					;ticks done
fps_updated:	ds.w	1					;updates done


fps_global:	ds.w	7+8
fps_control:	ds.w	12					;aes control structure
fps_int_in:	ds.w	30					;aes in parameters
fps_int_out:	ds.w	45					;aes out parameters
fps_addr_in:	ds.l	2					;aes address input
fps_addr_out:	ds.l	1					;aes address output


; --------------------------------------------------------------
		section	text
; --------------------------------------------------------------
